/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
/* * 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 8, 2003
 * Title : Validators.LoginValidator.java
 * Desprition : This Validators class is responsible for checking and validating the 
 * Customer Login .
 * 
 */
package Validators;
import nz.co.k.tms.ldap.*;


import JavaBeans.*;
/**
 * @author student
 *
 * This class is being used for validation of login data, ie username and
 * password.
 * 
 */
public class LoginValidator {
	
	private String message;
	
	/**
	 * This method is being used for getting an error message if the
	 * validation was unsuccessful.
	 * @return String The message to be displayed.
	 */
	public String getMessage(){
		return message;
	}
	
	/**
	 * This method is being used for setting an error message if the
	 * validation is unsuccessful.
	 * @param message The message to be displayed.
	 * @return void
	 */
	public void setMessage(String message){
		this.message = message;
	}
	
	/**
	 * This method is being used for login validaion.
	 * @param customerData The Customer details that are to be validated.
	 * @return boolean Specifies whether the validation was successful.
	 */
	public boolean validate(Customer_Data customerData){
		
		Customer_Data customerdata = customerData;
		String password ,userName;
		
		password = customerdata.getPassword();
		userName = customerdata.getUserName();	
		
		//check username and password.
		if(password == null || userName == null ){
			message = "Either password or username is blank.";
			return false;
		}
		//authenticate with the LDAP server.
		else {		
			try{
				UserDetail ud = LdapHelper.authentiacteUser(customerData.getUserName(), customerData.getPassword());
			}
			catch(Exception e){
				message = "Either password is wrong or user does not exist.";
				System.out.println("Unsuccessful login:");
				System.out.println("String : "+e.toString());
				return false;
			}
			return true;
		}
				
	}
}
